import java.util.*;
import java.io.*;

/**
 * Classe che incapsula il messaggio mandato e mostrato nel newsgroup
 * e permette di ottenere i singoli componenti 
 * @author Letizia Cheng Cheng Sun
 * @version 1.0
 *
 */
public class Msg implements Serializable{
	protected Person sender;
	protected Date timestamp;
	protected String object;
	protected String body;
	protected String msgID;
	
	/**
	 * Costruttore di Msg
	 * @param s sender del messaggio
	 * @param d data in cui il messaggio  stato inoltrato
	 * @param o oggetto del messaggio
	 * @param b corpo del messaggio
	 * @param ID Stringa rappresentante l'ID univoco del messaggio
	 * 			 
	 */
	public Msg(Person s,Date d,String o,String b,String ID){
		this.sender=s;
		this.timestamp=d;
		this.object=o;
		this.body=b;
		this.msgID=ID;
	}
	
	/**
	 * Costruttore di Msg
	 * @param s mittente del messaggio
	 * @param o oggetto del messagio
	 * @param b corpo del messaggio
	 * @param ID Stringa rappresentante l'ID univoco del messaggio
	 */
	public Msg(Person s,String o,String b,String ID){
		this.sender=s;
		this.timestamp=new Date();
		this.object=o;
		this.body=b;
		this.msgID=ID;
	}
	
	/**
	 * metodo che ritorna il mittente del messaggio
	 * @return mittente del messaggio
	 */
	public Person getSender(){
		return sender;
	}
	
	/**
	 * Metodo che ritorna la data di invio del messaggio
	 * @return data del messaggio
	 */
	public Date getTimestamp(){
		return timestamp;
	}
	
	/**
	 * Metodo che ritorna l'oggetto del messaggio
	 * @return oggetto del messaggio
	 */
	public String getObject(){
		return object;
	}
	
	/**
	 * Metodo che ritorna il corpo del messaggio
	 * @return corpo del messaggio
	 */
	public String getBody(){
		return body;
	}
	
	/**
	 * Metodo che ritorna l'identificativo univoco 
	 * associato al messaggio
	 * @return identificativo del messaggio
	 */
	public String getMsgID(){
		return msgID;
	}
	
	
	/**
	 * Metodo che specializza toString() della classe Object e d
	 * una descrizione degli elementi della classe
	 * @return stringa rappresentante la classe Msg
	 */
	public String toString(){
		String mitt="From:"+sender.getNickname();
		if(sender.getEmail()!=null)
				mitt=mitt.concat("<"+sender.getEmail()+">");
		return mitt+"\n"+timestamp+"\nobject:"+object+"\nMessageId="+ 
				msgID+"\n\n"+body;
	}
}
